import collections
import exceptions
import json
json.encoder.c_make_encoder = None
enc = json.JSONEncoder(separators=(', ', ': '), indent=2)
import time
import traceback
import urllib2

class NirvanaException(Exception):
    pass


class NirvanaErrorException(NirvanaException):
    pass


class NirvanaTooManyRetriesException(NirvanaException):
    pass


def CallJSONRPCNirvana(token, method, params, api_path = "https://nirvana.yandex-team.ru/api/public/v1",  id_value="cvdup_acceptance"):
    data = collections.OrderedDict()
    data["jsonrpc"] = "2.0"
    data["id"] = id_value
    data["method"] = method
    data["params"] = params
    jsData = enc.encode(data)
    url = "{0}/{1}".format(api_path, method)
    req = urllib2.Request(url)
    req.add_header("Authorization", 'OAuth {0}'.format(token))
    req.add_header("Content-Type", 'application/json')
    req.add_data(jsData)
    response = urllib2.urlopen(req)
    rslt = response.read()
    jsRslt = json.loads(rslt, object_pairs_hook=collections.OrderedDict)
    if isinstance(jsRslt, dict) and 'result' not in jsRslt:
        if 'error' in jsRslt and 'message' in jsRslt['error']:
            raise NirvanaErrorException(jsRslt['error']['message'])
        else:
            raise NirvanaErrorException('Unknown error')
    return jsRslt


def CallJSONRPCNirvanaWithRetry(token, method, params, api_path = "https://nirvana.yandex-team.ru/api/public/v1",  id_value="cvdup_acceptance", max_retry_count = 3):
    for try_no in range(max_retry_count):
        try:
            return CallJSONRPCNirvana(token, method, params, api_path, id_value)
        except NirvanaException:
            raise
        except:
            print traceback.format_exc()
            time.sleep(2**try_no)
    raise NirvanaTooManyRetriesException('Failed to make Json RPC call to Nirvana for method ' + method)


def CloneWorkflowInstance(token, workflow_id, workflow_instance_id, api_path = "https://nirvana.yandex-team.ru/api/public/v1", id_value="cvdup_acceptance"):
    params = collections.OrderedDict()
    params["workflowId"] = workflow_id
    params["workflowInstanceId"] = workflow_instance_id
    return CallJSONRPCNirvanaWithRetry(token, 'cloneWorkflowInstance', params, api_path, id_value)


def SetAllBlocksParameter(token, workflow_id, workflow_instance_id, parameter, value, api_path = "https://nirvana.yandex-team.ru/api/public/v1", id_value="cvdup_acceptance"):
    params = collections.OrderedDict()
    params["workflowId"] = workflow_id
    params["workflowInstanceId"] = workflow_instance_id
    params["params"] = []
    params["params"].append({'parameter' : parameter, 'value' : value})
    return CallJSONRPCNirvanaWithRetry(token, 'setBlockParameters', params, api_path, id_value)


def StartWorkflowInstance(token, workflow_id, workflow_instance_id, api_path = "https://nirvana.yandex-team.ru/api/public/v1", id_value="cvdup_acceptance"):
    params = collections.OrderedDict()
    params["workflowId"] = workflow_id
    params["workflowInstanceId"] = workflow_instance_id
    return CallJSONRPCNirvanaWithRetry(token, 'startWorkflow', params, api_path, id_value)


def GetExecutionState(token, workflow_id, workflow_instance_id, api_path = "https://nirvana.yandex-team.ru/api/public/v1", id_value="cvdup_acceptance"):
    params = collections.OrderedDict()
    params["workflowId"] = workflow_id
    params["workflowInstanceId"] = workflow_instance_id
    return CallJSONRPCNirvanaWithRetry(token, 'getExecutionState', params, api_path, id_value)


def GetAllBlocksResults(token, workflow_id, workflow_instance_id, api_path = "https://nirvana.yandex-team.ru/api/public/v1", id_value="cvdup_acceptance"):
    params = collections.OrderedDict()
    params["workflowId"] = workflow_id
    params["workflowInstanceId"] = workflow_instance_id
    return CallJSONRPCNirvanaWithRetry(token, 'getBlockResults', params, api_path, id_value)

