from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask

import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params

from sandbox.projects.images.daemons import resources as images_daemons_resources


class ImagesBuildCommercialDaemon(ReleaseToNannyTask, BaseMediaBuildTask):
    """
       Binary and config for commercial daemon
    """

    type = 'IMAGES_BUILD_COMMERCIAL_DAEMON'

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            images_daemons_resources.IMAGES_COMMERCIAL_DAEMON_EXECUTABLE
        )

    def get_configs(self):
        return (
            images_daemons_resources.IMAGES_COMMERCIAL_DAEMON_CONFIG,
            images_daemons_resources.IMAGES_COMMERCIAL_DAEMON_HAMSTER_CONFIG,
            images_daemons_resources.IMAGES_COMMERCIAL_DAEMON_PIP_CONFIG,
            images_daemons_resources.IMAGES_COMMERCIAL_DAEMON_CATEGORIES
        )


__Task__ = ImagesBuildCommercialDaemon
