from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask

import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params


class ImagesBuildCommercialDataBinaries(BaseMediaBuildTask):
    """
       Binaries for commercial data DB building
    """

    type = 'IMAGES_BUILD_COMMERCIAL_DATA_BINARIES'

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            resource_types.SHARDTOOL,
            resource_types.IMAGES_MR_INDEX_SHARDWRITER,
            resource_types.IMAGES_MAIN_COMMERCIAL_DATA_DOWNLOAD,
        )

    def get_configs(self):
        return (
            resource_types.SHARDTOOL_CONFIG_IMGS_COMMERCIAL_DATA
        )


__Task__ = ImagesBuildCommercialDataBinaries
