from sandbox.projects import resource_types

from sandbox.projects.common import BaseImagesBundleReplaces
from sandbox.projects.common.BaseImagesBuildBundle import BaseImagesBuildBundle


class ImagesBuildCommercialDataDeployBundle(BaseImagesBuildBundle):
    """
        Build commercial data deploy bundle.
    """

    type = 'IMAGES_BUILD_COMMERCIAL_DATA_DEPLOY_BUNDLE'

    __STABLE_SERVICES = ['mr_images_commercial_data']

    resource_replaces = (
        [resource_types.IMAGES_MR_INDEX_SHARDWRITER, BaseImagesBundleReplaces.ShardWriterReplace],
        [resource_types.SHARDTOOL, BaseImagesBundleReplaces.ShardToolReplace],
        [resource_types.IMAGES_MAIN_COMMERCIAL_DATA_DOWNLOAD, BaseImagesBundleReplaces.ShardDownloadReplace],
        [resource_types.SHARDTOOL_CONFIG_IMGS_COMMERCIAL_DATA, BaseImagesBundleReplaces.ShardToolConfigReplace],
    )

    input_parameters = BaseImagesBuildBundle.input_parameters + \
                       [param for _, param in resource_replaces]

    def get_built_resources(self):
        return (
            [resource_types.IMAGES_MR_INDEX_SHARDWRITER, 'shardwriter'],
            [resource_types.SHARDTOOL, 'shard_tool'],
            [resource_types.IMAGES_MAIN_COMMERCIAL_DATA_DOWNLOAD, 'shard_download'],
            [resource_types.SHARDTOOL_CONFIG_IMGS_COMMERCIAL_DATA, 'config.json'],
        )

    def get_resources(self):
        return ()

    def get_resource_type(self):
        return resource_types.IMAGES_COMMERCIAL_DATA_DEPLOY_BUNDLE

    def get_resource_replaces(self):
        return self.resource_replaces

    def get_resource_descr(self):
        return 'Commercial data deploy bundle'

    def get_resource_file_name(self):
        return 'imgs_commercial_data'

    def get_stable_services(self):
        return self.__STABLE_SERVICES


__Task__ = ImagesBuildCommercialDataDeployBundle
