# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects.common.BaseImagesBuildBundle import BaseImagesBuildBundle

from sandbox.projects.common import BaseImagesBundleReplaces
from sandbox.projects.GetImagesMrIndexConfig import GetImagesMrIndexConfig


class ImagesBuildFastCbirDeployBundle(BaseImagesBuildBundle):
    """
        Бандл для построения шарда быстрой сибири
    """

    type = 'IMAGES_BUILD_FAST_CBIR_DEPLOY_BUNDLE_V2'

    resource_replaces = (
        [resource_types.IMAGES_MR_INDEX_SHARDWRITER, BaseImagesBundleReplaces.ShardWriterReplace],
        [resource_types.SHARDTOOL, BaseImagesBundleReplaces.ShardToolReplace],
        [resource_types.SHARDTOOL_CONFIG, BaseImagesBundleReplaces.ShardToolConfigReplace],
        [resource_types.IMAGES_FAST_CBIR_SHARD_BUILDER, BaseImagesBundleReplaces.ShardBuilderReplace],
        [resource_types.IMAGES_FAST_CBIR_DOWNLOAD, BaseImagesBundleReplaces.ShardDownloadReplace],
        [resource_types.IMAGES_SHARDWRITER_CONFIG, BaseImagesBundleReplaces.ShardWriterConfigReplace],
    )

    input_parameters = BaseImagesBuildBundle.input_parameters + \
        [param for _, param in resource_replaces]

    __STABLE_SERVICES = ['mr_imgfcbr']
    __TESTING_SERVICES = ['mr_imgfcbr_test']

    def get_built_resources(self):
        return (
            [resource_types.IMAGES_MR_INDEX_SHARDWRITER, 'shardwriter'],
            [resource_types.SHARDTOOL, 'shard_tool'],
            [resource_types.IMAGES_FAST_CBIR_SHARD_BUILDER, 'shard_builder.sh'],
            [resource_types.IMAGES_FAST_CBIR_DOWNLOAD, 'shard_download'],
            [resource_types.SHARDTOOL_CONFIG, 'config.json'],
            [resource_types.IMAGES_MR_INDEX_COPYDOCATTRS, 'copydocattrs'],
        )

    def get_resources(self):
        return (
            [resource_types.IMAGES_SHARDWRITER_CONFIG, GetImagesMrIndexConfig.type, 'config'],
        )

    def get_resource_replaces(self):
        return self.resource_replaces

    def get_resource_type(self):
        return resource_types.IMAGES_FAST_CBIR_DEPLOY_BUNDLE

    def get_resource_descr(self):
        return 'Fast cbir deploy bundle'

    def get_resource_file_name(self):
        return 'imgfcbr'

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES


__Task__ = ImagesBuildFastCbirDeployBundle
