# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects.common.BaseImagesBuildIndexBundle import BaseImagesBuildIndexBundle, IndexConfigTask
from sandbox.projects.common import BaseImagesBundleReplaces

from sandbox.projects.images.ImagesBuildSearchBinary import ImagesBuildSearchBinary
from sandbox.projects.images.idx_ops import resources as images_idx_ops_resources


class ImagesBuildFastIndexDeployBundle(BaseImagesBuildIndexBundle):
    """
        Бандл для построения шарда быстрого картиного индекса
    """

    type = 'IMAGES_BUILD_FAST_INDEX_DEPLOY_BUNDLE_V2'

    __STABLE_SERVICES = ['mr_imgfbase']
    __TESTING_SERVICES = ['mr_imgfbase_test']

    resource_replaces = (
        [resource_types.IMAGES_MR_INDEX_SHARDWRITER, BaseImagesBundleReplaces.ShardWriterReplace],
        [resource_types.SHARDTOOL, BaseImagesBundleReplaces.ShardToolReplace],
        [resource_types.SHARDTOOL_CONFIG, BaseImagesBundleReplaces.ShardToolConfigReplace],
        [resource_types.IMAGES_FAST_INDEX_SHARD_BUILDER, BaseImagesBundleReplaces.ShardBuilderReplace],
        [resource_types.IMAGES_FAST_INDEX_DOWNLOAD, BaseImagesBundleReplaces.ShardDownloadReplace],
        [resource_types.IMAGES_SHARDWRITER_CONFIG, BaseImagesBundleReplaces.ShardWriterConfigReplace],
        [images_idx_ops_resources.IDX_OPS_IMAGES_EXECUTABLE, BaseImagesBundleReplaces.IdxOpsReplace],
        [resource_types.IMGSEARCH_SHARD_CHECKER_EXECUTABLE, BaseImagesBundleReplaces.ShardCheckerReplace],
        [resource_types.IMAGES_SHARD_UNINSTALL_SCRIPT, BaseImagesBundleReplaces.UninstallScriptReplace],
    )

    input_parameters = BaseImagesBuildIndexBundle.input_parameters + \
                       [param for _, param in resource_replaces]

    def get_built_resources(self):
        return (
            [resource_types.IMAGES_MR_INDEX_SHARDWRITER, 'shardwriter'],
            [resource_types.SHARDTOOL, 'shard_tool'],
            [resource_types.IMAGES_FAST_INDEX_SHARD_BUILDER, 'shard_builder.sh'],
            [resource_types.IMAGES_FAST_INDEX_DOWNLOAD, 'shard_download'],
            [resource_types.SHARDTOOL_CONFIG, 'config.json'],
            [resource_types.IMAGES_SHARD_UNINSTALL_SCRIPT, 'iss-uninstall'],
        )

    def get_resources(self):
        return (
            [images_idx_ops_resources.IDX_OPS_IMAGES_EXECUTABLE, ImagesBuildSearchBinary.type, 'idx_ops_images'],
            [resource_types.IMGSEARCH_SHARD_CHECKER_EXECUTABLE, ImagesBuildSearchBinary.type, 'shard_checker'],
        )

    def get_resources_from_tasks(self):
        return (
            [resource_types.IMAGES_SHARDWRITER_CONFIG, self.ctx.get(IndexConfigTask.name), 'config'],
        )

    def get_resource_replaces(self):
        return self.resource_replaces

    def get_resource_type(self):
        return resource_types.IMAGES_FAST_INDEX_DEPLOY_BUNDLE

    def get_resource_descr(self):
        return 'Fast index deploy bundle'

    def get_resource_file_name(self):
        return 'imgfbase'

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES


__Task__ = ImagesBuildFastIndexDeployBundle
