# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask


class ImagesBuildKoschei(nanny.ReleaseToNannyTask, BaseMediaBuildTask):
    """
        Собирает скрипты и данные для картиночных вьюверов (Кощея).
    """
    type = "IMAGES_BUILD_KOSCHEI"

    def get_binaries(self):
        return (
            resource_types.IMAGES_PICKMRLINK_EXECUTABLE,
            resource_types.MAPREDUCE_EXECUTABLE,
            resource_types.IMAGES_MR_INDEX_DOCID_VIEWER,
            resource_types.IMAGES_LINKDB_EXECUTABLE,
            resource_types.IMAGES_URLDB_EXECUTABLE,
            resource_types.IMAGES_KWWORM_EXECUTABLE,
            resource_types.IMAGES_ZORACL_EXECUTABLE,
            resource_types.IMAGES_UKROP_PRINT_UDF_EXECUTABLE,
            resource_types.IMAGES_ESCAPE_EXECUTABLE,
            resource_types.IMAGES_SITACL_EXECUTABLE,
            resource_types.IMAGES_PROTOC_EXECUTABLE,
            resource_types.IMAGES_DUMPTREC_EXECUTABLE,
            resource_types.IMAGES_DUMPTRACE_EXECUTABLE,
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_VIEWERS,
        )


__Task__ = ImagesBuildKoschei
