from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask

import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params

from sandbox.projects.images.daemons import resources as images_daemons_resources


class ImagesBuildLikesAggregateDaemon(ReleaseToNannyTask, BaseMediaBuildTask):
    """
       Binary and config for likes daemon
    """

    type = 'IMAGES_BUILD_LIKES_AGGREGATE_DAEMON'

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            images_daemons_resources.LIKES_AGGREGATE_DAEMON_EXECUTABLE
        )

    def get_configs(self):
        return (
            images_daemons_resources.LIKES_AGGREGATE_DAEMON_CONFIG
        )


__Task__ = ImagesBuildLikesAggregateDaemon
