# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects.common.BaseImagesBuildBundle import BaseImagesBuildBundle
from sandbox.projects.common import BaseImagesBundleReplaces


class ImagesBuildMainImtubDeployBundle(BaseImagesBuildBundle):
    """
        Бандл для построения шарда больших имтубов
    """

    type = 'IMAGES_BUILD_MAIN_IMTUB_DEPLOY_BUNDLE_V2'

    __STABLE_SERVICES = []

    resource_replaces = (
        [resource_types.IMAGES_MR_INDEX_SHARDWRITER, BaseImagesBundleReplaces.ShardWriterReplace],
        [resource_types.IMAGES_MAIN_IMTUB_DOWNLOAD, BaseImagesBundleReplaces.ShardDownloadReplace],
        [resource_types.IMAGES_MR_INDEX_THDB, BaseImagesBundleReplaces.ThdbReplace],
        [resource_types.IMAGES_MAIN_IMTUB_INSTALL_SCRIPT, BaseImagesBundleReplaces.InstallScriptReplace],
    )

    input_parameters = BaseImagesBuildBundle.input_parameters + \
                       [param for _, param in resource_replaces]

    def get_built_resources(self):
        return (
            [resource_types.IMAGES_MR_INDEX_SHARDWRITER, 'shardwriter'],
            [resource_types.IMAGES_MAIN_IMTUB_DOWNLOAD, 'shard_download'],
            [resource_types.IMAGES_MR_INDEX_THDB, 'thdb'],
            [resource_types.IMAGES_MAIN_IMTUB_INSTALL_SCRIPT, 'install.sh'],
        )

    def get_resources(self):
        return ()

    def get_resource_type(self):
        return resource_types.IMAGES_MAIN_IMTUB_DEPLOY_BUNDLE

    def get_resource_replaces(self):
        return self.resource_replaces

    def get_resource_descr(self):
        return 'Main imtub deploy bundle'

    def get_resource_file_name(self):
        return 'imgsth'

    def get_stable_services(self):
        return self.__STABLE_SERVICES


__Task__ = ImagesBuildMainImtubDeployBundle
