# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.images.rtcvdup import resources as rtcvdup_resources
import sandbox.projects.images.resource_types as images_resource_types
import sandbox.projects.images.util as util_functions
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts


class ImagesBuildMainIndexBinaries(BaseMediaBuildTask):
    """
        Бинарники для построения индекса на MR
    """

    type = 'IMAGES_BUILD_MAIN_INDEX_BINARIES'
    execution_space = 110*1024  # 110 Gb

    input_parameters = util_functions.set_default_selective_checkout_to_true(BaseMediaBuildTask.input_parameters)

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[consts.THINLTO] = True
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.YMAKE_BUILD_SYSTEM
        self.ctx['kill_timeout'] = 8 * 60 * 60

    def get_binaries(self):
        return (
            resource_types.IMAGES_MR_INDEX_CBIR,
            resource_types.IMAGES_MR_INDEX_CBIR_INDEXER,
            resource_types.IMAGES_MR_INDEX_CLEANUP,
            resource_types.IMAGES_MR_INDEX_COPYDOCATTRS,
            resource_types.IMAGES_MR_INDEX_DOCCOUNTER,
            resource_types.IMAGES_MR_INDEX_DOCID_VIEWER,
            resource_types.IMAGES_MR_INDEX_EXPORT2UKROP,
            resource_types.IMAGES_MR_INDEX_FEEDBACK,
            resource_types.IMAGES_MR_INDEX_ID2URL,
            resource_types.IMAGES_MR_INDEX_IDXCONVERT,
            resource_types.IMAGES_MR_INDEX_IDXTHUMB,
            resource_types.IMAGES_MR_INDEX_IMGTRIEBUILDER,
            resource_types.IMAGES_MR_INDEX_INDEXBUILDER,
            resource_types.IMAGES_MR_INDEX_INDEXDELTA,
            resource_types.IMAGES_MR_INDEX_INDEXMERGE,
            resource_types.IMAGES_MR_INDEX_INPUT,
            resource_types.IMAGES_MR_INDEX_INPUTDOC,
            resource_types.IMAGES_MR_INDEX_METADOC,
            resource_types.IMAGES_MR_INDEX_NNINDEXER,
            resource_types.IMAGES_MR_INDEX_PLANNER,
            resource_types.IMAGES_MR_INDEX_PORNOBAN,
            resource_types.IMAGES_MR_INDEX_RATEDCONVERT,
            resource_types.IMAGES_MR_INDEX_RATEDINDEX,
            resource_types.IMAGES_MR_INDEX_REMAPINDEX,
            resource_types.IMAGES_MR_INDEX_SELECTIONRANK,
            resource_types.IMAGES_MR_INDEX_SHARDWRITER,
            resource_types.IMAGES_MR_INDEX_SHARDPREPARER,
            resource_types.IMAGES_MR_INDEX_STATISTICS,
            images_resource_types.IMAGES_MR_INDEX_STATISTICS_HNSW,
            resource_types.IMAGES_MR_INDEX_FACTORDIFF,
            resource_types.IMAGES_MR_INDEX_THDB,
            resource_types.IMAGES_MR_INDEX_TRACEROUTE,
            resource_types.IMAGES_MR_INDEX_USERDOC,
            resource_types.IMAGES_MR_INDEX_USERTRIE,
            resource_types.IMAGES_XDELTA,
            resource_types.SHARDTOOL,
            resource_types.SHARDTOOL_CLUSTER_STATE,
            resource_types.IMAGES_CRCDB_EXECUTABLE,
            resource_types.IMAGES_IMAGEDB_EXECUTABLE,
            resource_types.IMAGES_MR_TAAS_MKTHDB,
            resource_types.IMAGES_LINKDB_EXECUTABLE,
            resource_types.IMAGES_URLDB_EXECUTABLE,
            resource_types.IMAGES_MAIN_CBIR_DOWNLOAD,
            resource_types.IMAGES_MAIN_IMTUB_DOWNLOAD,
            resource_types.IMAGES_MAIN_INDEX_DOWNLOAD,
            resource_types.IMAGES_MAIN_RIM_DOWNLOAD,
            resource_types.IMAGES_META_DOWNLOAD,
            resource_types.IMAGES_MR_INDEX_ROTATE,
            resource_types.IMAGES_DOWNLOAD_RESOURCE_EXECUTABLE,
            images_resource_types.IMAGES_RELEASE_RESOURCES_EXECUTABLE,
            images_resource_types.IMAGES_CALLISTO_HELPER,
            images_resource_types.IMAGES_MR_INDEX_HOSTFACTORS_STATISTICS,
            rtcvdup_resources.IMAGES_RTCVDUP_EXECUTABLE,
            images_resource_types.IMAGES_RTCVDUP_VIEWER_EXECUTABLE,
            images_resource_types.IMAGES_RTROBOT_DBWALKER_EXECUTABLE,
            images_resource_types.IMAGES_BIN_WRANGLER,
            images_resource_types.IMAGES_LINKDB_CLEANUPER,
            images_resource_types.IMAGES_BIN_YT_STATE_TOOL,
            images_resource_types.IMAGES_BIN_YT_QUEUE_TOOL,
            images_resource_types.IMAGES_BIN_YT_OPERATION_TOOL,
            images_resource_types.IMAGES_CRCDB_DYNTAB_EXECUTABLE,
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_MAIN_CBIR_SHARD_BUILDER,
            resource_types.IMAGES_MAIN_IMTUB_INSTALL_SCRIPT,
            resource_types.IMAGES_MAIN_IMTUB_SHARD_BUILDER,
            resource_types.IMAGES_MAIN_INDEX_HOSTS_LIST,
            resource_types.IMAGES_MAIN_INDEX_INSTALL_SCRIPT,
            resource_types.IMAGES_SHARD_UNINSTALL_SCRIPT,
            resource_types.IMAGES_MAIN_INDEX_SHARD_BUILDER,
            resource_types.IMAGES_META_SHARD_BUILDER,
            resource_types.IMAGES_MR_INDEX_SPOK_SHARE,
            resource_types.IMAGES_MR_INDEX_STATISTICS_PRETTY_PRINT,
            resource_types.SHARDTOOL_CONFIG,
            resource_types.SHARDTOOL_CONFIG_IMGSBASE,
            resource_types.SHARDTOOL_CONFIG_IMGSCBR,
            resource_types.SHARDTOOL_CONFIG_IMGSRIM,
            resource_types.SHARDTOOL_CONFIG_IMGSTH,
            rtcvdup_resources.IMAGES_RTCVDUP_MAN_CONFIG,
            images_resource_types.IMAGES_RTCVDUP_VIEWER_CONFIG,
            images_resource_types.IMAGES_RTCVDUP_VIEWER_STATIC,
            images_resource_types.IMAGES_RTCVDUP_VIEWER_TEMPLATES,
            images_resource_types.IMAGES_RTROBOT_DBWALKER_CONFIG,
        )


__Task__ = ImagesBuildMainIndexBinaries
