# -*- coding: utf-8 -*-

from sandbox.projects.common.BaseImagesBuildIndexBundles import BaseImagesBuildIndexBundles
from sandbox.projects.common.BaseImagesBuildIndexBundle import IndexConfigTask
from sandbox.projects.common.priemka.BasePriemkaTask import generate_priemka_parameters
import sandbox.projects.common.build.parameters as build_params

from sandbox.projects.images.ImagesBuildCmPackage import ImagesBuildCmPackage
from sandbox.projects.images.ImagesBuildMainImtubDeployBundle_v2 import ImagesBuildMainImtubDeployBundle
from sandbox.projects.images.ImagesBuildMainIndexDeployBundle_v2 import ImagesBuildMainIndexDeployBundle
from sandbox.projects.images.ImagesBuildMetaDeployBundle_v2 import ImagesBuildMetaDeployBundle

from sandbox.projects.images.ImagesBuildMainIndexBinaries import ImagesBuildMainIndexBinaries


class ImagesBuildMainIndexBundles(BaseImagesBuildIndexBundles):
    """
        Build all Images MR Indexer bundles
    """

    type = 'IMAGES_BUILD_MAIN_INDEX_BUNDLES'

    input_parameters = generate_priemka_parameters(ImagesBuildMainIndexBinaries.type)

    def initCtx(self):
        self.ctx[build_params.StripBinaries.name] = True

    def get_bundle_types(self):
        subtask_ctx = {IndexConfigTask.name: self.get_mr_index_config_task()}
        return (
            [ImagesBuildMainImtubDeployBundle.type, {}],
            [ImagesBuildMetaDeployBundle.type, {}],
            [ImagesBuildMainIndexDeployBundle.type, subtask_ctx],
            [ImagesBuildCmPackage.type, {}],
        )

    @classmethod
    def get_build_task_type(self):
        return ImagesBuildMainIndexBinaries.type


__Task__ = ImagesBuildMainIndexBundles
