# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.images import resource_types as images_resource_types
from sandbox.projects.images.thumbrella import resources as thumbrella_resources
from sandbox.projects.images.ImagesBuildMainIndexBinaries import ImagesBuildMainIndexBinaries


class ImagesBuildMainIndexNightlyBinaries(ImagesBuildMainIndexBinaries):
    """
        Бинарники для построения тестовых индексных баз и индекса уменьшенного размера
    """

    type = 'IMAGES_BUILD_MAIN_INDEX_NIGHTLY_BINARIES'
    execution_space = 80000

    def get_binaries(self):
        result = ImagesBuildMainIndexBinaries.get_binaries(self)

        return result + (
            thumbrella_resources.IMAGES_THUMBRELLA_EXECUTABLE,
            thumbrella_resources.IMAGES_THUMBRELLA_SYNC_EXECUTABLE,
            images_resource_types.IMAGES_YTCLOUD_PREPARE_EXECUTABLE,
            images_resource_types.IMAGES_YTCLOUD_YQLRUNNER_EXECUTABLE,
            images_resource_types.IMAGES_RTHUB_TOOL_EXECUTABLE,
        )


__Task__ = ImagesBuildMainIndexNightlyBinaries
