# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxIntegerParameter
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk import sandboxapi

from sandbox.projects.common.priemka import BasePriemkaTask
from sandbox.projects.common.BaseImagesBuildIndexBundles import BaseImagesBuildIndexBundles
from sandbox.projects.images.ImagesBuildMainIndexNightlyBinaries import ImagesBuildMainIndexNightlyBinaries

import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params


class ImagesBuildMainIndexNightlyBundles(BaseImagesBuildIndexBundles):
    """
        Build all Images MR Indexer binaries from a particular revision of trunk
    """

    type = 'IMAGES_BUILD_MAIN_INDEX_NIGHTLY_BUNDLES'

    class RevisionParameter(SandboxIntegerParameter):
        """
            Revision repository number
            '0' value means that HEAD revision will be used
        """
        name = BasePriemkaTask.REVISION_PARAMETER_NAME
        description = 'SVN revision'
        required = False

    def get_bundle_types(self):
        return ()

    input_parameters = (RevisionParameter,)

    def on_execute(self):
        if self.BUILD_TASK_KEY not in self.ctx:
            trunk_url = Arcadia.trunk_url(revision=self.ctx.get(BasePriemkaTask.REVISION_PARAMETER_NAME))
            self.ctx[self.DESCRIPTION_KEY] = 'Build from trunk'
            build_task_ctx = {
                consts.ARCADIA_URL_KEY: trunk_url,
                build_params.StripBinaries.name: False
            }

            self.ctx[self.BUILD_TASK_KEY] = self.create_subtask(
                self.get_build_task_type(),
                self.ctx[self.DESCRIPTION_KEY],
                input_parameters=build_task_ctx,
                arch=sandboxapi.ARCH_LINUX
            ).id

        BaseImagesBuildIndexBundles.on_execute(self)

    @classmethod
    def get_build_task_type(self):
        return ImagesBuildMainIndexNightlyBinaries.type


__Task__ = ImagesBuildMainIndexNightlyBundles
