from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.images.resource_types as images_resources
from sandbox.projects.images.rim import resources as rim_resources


class ImagesBuildMainRimBinaries(nanny.ReleaseToNannyTask, BaseMediaBuildTask):
    """
       Binaries for RIM DB building
    """

    type = 'IMAGES_BUILD_MAIN_RIM_BINARIES'
    execution_space = 100*1024  # 80 GB

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True
        self.ctx[consts.THINLTO] = True
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.SEMI_DISTBUILD_BUILD_SYSTEM

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)

    def get_binaries(self):
        return (
            resource_types.IMAGES_RIMDB_EXECUTABLE,
            resource_types.IMAGES_RIMDB_TOOLS,
            resource_types.IMAGES_RIMDB_EVALUATION,
            resource_types.IMAGES_DOWNLOAD_RESOURCE_EXECUTABLE,
            images_resources.IMAGES_RIMDB_SERPS_COMPARE,
            images_resources.IMAGES_RIMDB_LEARN,
            images_resources.IMAGES_RELEASE_RESOURCES_EXECUTABLE,
            rim_resources.IMAGES_RIMDB_RIMTHUMBS_EXECUTABLE,
            rim_resources.IMAGES_RIMDB_SCHEMAORG_EXECUTABLE,
            rim_resources.IMAGES_RIMDB_RIM_SHARDS_SIZE_EXECUTABLE,
            rim_resources.IMAGES_RIMDB_YT_DAEMON_EXECUTABLE,
            rim_resources.IMAGES_RIM_TOOLS_TAAS_RUN_TIME_EXECUTABLE,
            rim_resources.IMAGES_RIM_RIMDB_BUILDER_PARSE_METADOC_EXECUTABLE
        )

    def get_configs(self):
        return (
        )


__Task__ = ImagesBuildMainRimBinaries
