# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects.common.BaseImagesBuildIndexBundle import BaseImagesBuildIndexBundle
from sandbox.projects.common import BaseImagesBundleReplaces


class ImagesBuildMetaDeployBundle(BaseImagesBuildIndexBundle):
    """
        Бандл для построения шарда для среднего метапоиска
    """

    type = 'IMAGES_BUILD_META_DEPLOY_BUNDLE_V2'

    __STABLE_SERVICES = []
    __TESTING_SERVICES = []

    resource_replaces = (
        [resource_types.IMAGES_SHARDWRITER_CONFIG, BaseImagesBundleReplaces.ShardWriterConfigReplace],
    )

    input_parameters = BaseImagesBuildIndexBundle.input_parameters + \
                       [param for _, param in resource_replaces]

    def get_built_resources(self):
        return [
            [resource_types.IMAGES_MR_INDEX_SHARDWRITER, 'shardwriter'],
            [resource_types.SHARDTOOL, 'shard_tool'],
            [resource_types.IMAGES_META_SHARD_BUILDER, 'shard_builder.sh'],
            [resource_types.IMAGES_META_DOWNLOAD, 'shard_download'],
            [resource_types.SHARDTOOL_CONFIG, 'config.json']
        ]

    def get_resources(self):
        return []

    def get_resources_from_tasks(self):
        return (
            [resource_types.IMAGES_SHARDWRITER_CONFIG, self.get_config_task(), 'config'],
        )

    def get_resource_type(self):
        return resource_types.IMAGES_META_DEPLOY_BUNDLE

    def get_resource_descr(self):
        return 'Main meta deploy bundle'

    def get_resource_file_name(self):
        return 'imgmmeta'

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES


__Task__ = ImagesBuildMetaDeployBundle
