import argparse
import os

import yt.wrapper as yt


class EventFilter(object):
    def __call__(self, row):
        if row.get('event_type') in ['EnqueueYSRequest', 'ContextCreated']:
            yield row


class RequestFilter(object):
    def __init__(self, collection):
        self._collection = collection

    def __call__(self, key, rows):
        coll = None
        context = None

        for row in rows:
            if row.get('event_type') == 'EnqueueYSRequest':
                split = row['event_data'].split()
                if len(split) > 3:
                    request_collection = split[3][1:] # has form /yandsearch or /imagesultra p.e.
                    if request_collection == self._collection:
                        coll = request_collection

            if row.get('event_type') == 'ContextCreated':
                context = {'request': 'http://localhost:8030/{}?{}&nocache=da'.format(self._collection, row['event_data'].split()[0])}

        if coll and context:
            yield context


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', help='YT proxy', required=True)
    parser.add_argument('--source-table', help='Source table', required=True)
    parser.add_argument('--output-table', help='Output table', required=True)
    parser.add_argument('--collection', help='Collection', required=True)

    return parser.parse_args()


def main():
    args = parse_args()

    yt.config['proxy']['url'] = args.yt_proxy
    yt.config['pickling']['python_binary'] = '/skynet/python/bin/python'
    yt.config['token'] = os.environ.get('YT_TOKEN')

    yt.run_map_reduce(EventFilter(), RequestFilter(collection=args.collection), args.source_table, args.output_table, reduce_by='frame_id')


if __name__ == '__main__':
    main()
