# coding: utf-8

import sandbox.common.types.client as ctc

import sandbox.projects.common.build.parameters as build_params

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.nanny import auto_deploy


class ImagesPackageParameter(YaPackage.PackagesParameter):
    default_value = 'extsearch/images/money/scripts/money_robot.json'


class ImagesPackageTypeParameter(YaPackage.ResourceTypeParameter):
    default_value = 'IMAGES_MONEY_ROBOT_PACKAGE'


class StripBinariesParameter(YaPackage.StripBinariesParameter):
    default_value = True


class ImagesBuildMoneyRobotPackage(YaPackage.YaPackage, auto_deploy.AutoNannyDeployTask):
    type = 'IMAGES_BUILD_MONEY_ROBOT_PACKAGE'

    __STABLE_SERVICES = ['sas_imgs_market']

    input_parameters = (
        parameters.SandboxArcadiaUrlParameter,
        ImagesPackageParameter,
        ImagesPackageTypeParameter,
        build_params.ArcadiaPatch,
        StripBinariesParameter,
    )

    client_tags = ctc.Tag.SSD
    execution_space = 5 * 1024

    def on_enqueue(self):
        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value

        self.ctx.update({YaPackage.PackageTypeParameter.name: YaPackage.TARBALL})
        self.ctx.update({YaPackage.PublishPackageParameter.name: False})
        YaPackage.YaPackage.on_enqueue(self)

    def on_release(self, additional_parameters):
        YaPackage.YaPackage.on_release(self, additional_parameters)
        auto_deploy.AutoNannyDeployTask.on_release(self, additional_parameters)

    def get_nanny_oauth_token(self):
        return self.get_vault_data('IMAGES-BASE-DEPLOY', 'ROBOT_IMGSBASE_NANNY_TOKEN')

    def get_stable_services(self):
        return self.__STABLE_SERVICES


__Task__ = ImagesBuildMoneyRobotPackage
