# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.images import resource_types as images_resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts


class ImagesBuildMrdbBinaries(BaseMediaBuildTask):
    """
        Бинарники для периодического обновления баз, не входящих в основной цикл построения индекса
    """

    type = 'IMAGES_BUILD_MRDB_BINARIES'
    execution_space = 100 * 1024  # 100 GB

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[consts.THINLTO] = True

    def get_binaries(self):
        return (
            resource_types.IMAGES_USERDATA_STATISTICS,
            resource_types.IMAGES_USERDB_FASTLOGSPARSER,
            resource_types.IMAGES_USERDB_MERGESTATE,
            resource_types.IMAGES_USERDB_USERSESSIONS,
            resource_types.IMAGES_URLDB_EXECUTABLE,
            resource_types.IMAGES_MR_INDEX_PORNOBAN,
            resource_types.IMAGES_MR_INDEX_ID2URL,
            resource_types.IMAGES_MR_INDEX_SEMIDUPS,
            resource_types.IMAGES_TAGS_BUILD_MAIN,
            resource_types.IMAGES_TAGS_BUILD_HOMONYMS,
            resource_types.IMAGES_TAGS_BUILD_GZT,
            resource_types.IMAGES_FACTORS_TOLOKA_TOP_REQUESTS,
            resource_types.IMAGES_MRDB_HOSTDB,
            resource_types.IMAGES_MRDB_BAN404,
            resource_types.IMAGES_MRDB_BADCLICKS,
            resource_types.IMAGES_MRDB_NASTY_IMAGES,
            resource_types.IMAGES_DOWNLOAD_RESOURCE_EXECUTABLE,
            images_resource_types.IMAGES_RELEASE_RESOURCES_EXECUTABLE,
            images_resource_types.IMAGES_TAGS_DICT_UTIL_EXECUTABLE,
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_TAGS_FILTER_STOPWORDS
        )


__Task__ = ImagesBuildMrdbBinaries
