# -*- coding: utf-8 -*-

from sandbox.projects.common.BaseImagesBuildIndexBundles import BaseImagesBuildIndexBundles
from sandbox.projects.common.priemka.BasePriemkaTask import generate_priemka_parameters

from sandbox.projects.GetImagesMrIndexConfig import GetImagesMrIndexConfig

from sandbox.projects.images.ImagesBuildMrdbBinaries import ImagesBuildMrdbBinaries


class ImagesBuildMrdbBundles(BaseImagesBuildIndexBundles):
    """
        Build mrdb bundles. Currently it contains only binaries
    """

    type = 'IMAGES_BUILD_MRDB_BUNDLES'

    input_parameters = generate_priemka_parameters(ImagesBuildMrdbBinaries.type)

    def get_bundle_types(self):
        return ()

    def on_execute(self):
        self.ctx[GetImagesMrIndexConfig.type] = None
        BaseImagesBuildIndexBundles.on_execute(self)

    @classmethod
    def get_build_task_type(self):
        return ImagesBuildMrdbBinaries.type


__Task__ = ImagesBuildMrdbBundles
