# coding: utf-8

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts

from sandbox.projects.common.build.ya_package_config import consts as ya_package_consts
from sandbox.projects.common.build.KosherYaPackage import KosherYaPackage
from sandbox.projects.common.nanny import nanny


class ImagesBuildOntoSearchPackage(KosherYaPackage, nanny.ReleaseToNannyTask2):

    class Requirements(KosherYaPackage.Requirements):
        pass

    class Parameters(KosherYaPackage.Parameters):
        resource_type = build_params.ResourceType(default_value='IMAGES_ONTOSEARCH_ROBOT_PACKAGE')
        packages = build_params.Packages(default_value='extsearch/images/ontosearch/robot/resources/IMAGES_ONTOSEARCH_ROBOT_PACKAGE.json')
        build_type = build_params.BuildType(default_value=consts.RELEASE_BUILD_TYPE)
        publish_package = build_params.PublishPackage(default_value=False)
        raw_package = build_params.RawPackage(default_value=False)
        package_type = build_params.PackageType(default_value=ya_package_consts.PackageType.TARBALL.value)
        do_not_remove_resources = build_params.DoNotRemoveResources2(default_value=False)
        strip_binaries = build_params.StripBinaries2(default_value=True)

    def on_enqueue(self):
        super(ImagesBuildOntoSearchPackage, self).on_enqueue()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        super(ImagesBuildOntoSearchPackage, self).on_release(additional_parameters)
