# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
from sandbox.projects.common.nanny import auto_deploy


class BuildImagesTaasBundle(BaseMediaBuildTask, auto_deploy.AutoNannyDeployTask):
    """
        Бинарники для прокачки тумбов, построения стейта на выкладку ТааS на MR
    """

    type = 'BUILD_IMAGES_TAAS_BUNDLE'
    execution_space = 20000

    __STABLE_SERVICES = ['taas_dashboard']
    __TESTING_SERVICES = []

    def get_binaries(self):
        return (
            resource_types.IMAGES_MR_INDEX_TAAS_BACKOFFICE,
            resource_types.IMAGES_MR_INDEX_TAAS_CLIENT,
            resource_types.IMAGES_MR_INDEX_MKIMTUB_TAAS,
            resource_types.IMAGES_TAAS_SERVICE,
            resource_types.IMAGES_TAAS_DASHBOARD,
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_TAAS_DASHBOARD_CONFIG,
            resource_types.IMAGES_TAAS_DASHBOARDS_TEMPLATES,
            resource_types.IMAGES_TAAS_DASHBOARDS_STATIC_RESOURCES,
        )

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES

    def get_nanny_oauth_token(self):
        return self.get_vault_data('IMAGES-BASE-DEPLOY', 'ROBOT_IMGSBASE_NANNY_TOKEN')


__Task__ = BuildImagesTaasBundle
