# -*- coding: utf-8 -*-

import logging
import os

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter
#from sandbox.sandboxsdk.errors import SandboxTaskFailureError
#from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.paths import make_folder

from sandbox import sdk2

from sandbox.projects import resource_types


class IMAGES_TAGS_MMETA_MODELS_BUNDLE(sdk2.Resource):
    """
        Модели переранжирования тегов на среднем. Релизятся вручную через REMOTE_COPY_RESOURCE.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = resource_types.images_tags_releasers
    release_subscribers = resource_types.images_tags_subscribers
    ttl = 'inf'


class DataPaths(SandboxStringParameter):
    multiline = True
    name, description = 'data_paths', 'Path to tags models&data on svn'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/merge_tags_compress_link.cfg\n'\
                    'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/merge_tags_compress_link.model\n'


class ImagesBuildTagsMmetaModelsBundle(SandboxTask):
    """
        Gathers data&models needed for ImgMergeTags on mmeta.
    """
    type = 'IMAGES_BUILD_TAGS_MMETA_MODELS_BUNDLE'

    input_parameters = [DataPaths]

    def on_execute(self):
        data_paths = self.ctx.get('data_paths')
        data_paths = data_paths.split('\n')

        logging.info('files to copy: {}'.format(', '.join(data_paths)))

        models_path = self.abs_path('images_tags_mmeta_models_bundle')
        make_folder(models_path)
        for fname in data_paths:
            if len(fname) == 0:
                continue
            dest_path = os.path.join(models_path, os.path.basename(fname))
            self.remote_copy(fname, dest_path, create_resource=False)

        mod_res = self.create_resource('Images merge tags data bundle. Description: ' + self.descr, models_path, IMAGES_TAGS_MMETA_MODELS_BUNDLE)
        self.mark_resource_ready(mod_res.id)

    def arcadia_info(self):
        return None, 'nobranch', None


__Task__ = ImagesBuildTagsMmetaModelsBundle
