# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.images import resource_types as images_resource_types
import sandbox.projects.images.util as util_functions
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts


class ImagesBuildUltraIndexBinaries(BaseMediaBuildTask):
    """
        Бинарники для построения быстрого индекса на MR
    """

    type = 'IMAGES_BUILD_ULTRA_INDEX_BINARIES'
    execution_space = 120000

    input_parameters = util_functions.set_default_selective_checkout_to_true(BaseMediaBuildTask.input_parameters)

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False

    def get_binaries(self):
        return (
            resource_types.IMAGES_MR_INDEX_CBIR,
            resource_types.IMAGES_MR_INDEX_CBIR_INDEXER,
            resource_types.IMAGES_MR_INDEX_CLEANUP,
            resource_types.IMAGES_MR_INDEX_COPYDOCATTRS,
            resource_types.IMAGES_MR_INDEX_DOCCOUNTER,
            resource_types.IMAGES_MR_INDEX_DOCID_VIEWER,
            resource_types.IMAGES_MR_INDEX_EXPORT2UKROP,
            resource_types.IMAGES_MR_INDEX_FASTANNDATA,
            resource_types.IMAGES_MR_INDEX_FEEDBACK,
            resource_types.IMAGES_MR_INDEX_IDXCONVERT,
            resource_types.IMAGES_MR_INDEX_IDXTHUMB,
            resource_types.IMAGES_MR_INDEX_IMGTRIEBUILDER,
            resource_types.IMAGES_MR_INDEX_INDEXBUILDER,
            resource_types.IMAGES_MR_INDEX_INDEXDELTA,
            resource_types.IMAGES_MR_INDEX_INDEXMERGE,
            resource_types.IMAGES_MR_INDEX_INPUT,
            resource_types.IMAGES_MR_INDEX_INPUTDOC,
            resource_types.IMAGES_MR_INDEX_METADOC,
            resource_types.IMAGES_MR_INDEX_NNINDEXER,
            resource_types.IMAGES_MR_INDEX_PLANNER,
            resource_types.IMAGES_MR_INDEX_PORNOBAN,
            resource_types.IMAGES_MR_INDEX_RATEDCONVERT,
            resource_types.IMAGES_MR_INDEX_RATEDINDEX,
            resource_types.IMAGES_MR_INDEX_REMAPINDEX,
            resource_types.IMAGES_MR_INDEX_SELECTIONRANK,
            resource_types.IMAGES_MR_INDEX_SHARDWRITER,
            resource_types.IMAGES_MR_INDEX_STATISTICS,
            resource_types.IMAGES_MR_INDEX_THDB,
            resource_types.IMAGES_MR_INDEX_TRACEROUTE,
            resource_types.IMAGES_MR_INDEX_USERDOC,
            resource_types.IMAGES_MR_INDEX_USERTRIE,
            resource_types.IMAGES_XDELTA,
            resource_types.SHARDTOOL,
            resource_types.SHARDTOOL_CLUSTER_STATE,
            resource_types.IMAGES_IMAGEDB_EXECUTABLE,
            resource_types.IMAGES_MR_TAAS_MKTHDB,
            resource_types.IMAGES_LINKDB_EXECUTABLE,
            resource_types.IMAGES_URLDB_EXECUTABLE,
            resource_types.IMAGES_MDSPUSH_EXECUTABLE,
            resource_types.IMAGES_UPLOADSAAS_EXECUTABLE,
            resource_types.IMAGES_DOWNLOAD_RESOURCE_EXECUTABLE,
            images_resource_types.IMAGES_RELEASE_RESOURCES_EXECUTABLE,
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_FAST_CBIR_SHARD_BUILDER,
            resource_types.IMAGES_FAST_IMTUB_INSTALL_SCRIPT,
            resource_types.IMAGES_FAST_IMTUB_SHARD_BUILDER,
            resource_types.IMAGES_FAST_INDEX_HOSTS_LIST,
            resource_types.IMAGES_MR_INDEX_SPOK_SHARE,
            resource_types.IMAGES_MR_INDEX_STATISTICS_PRETTY_PRINT,
            resource_types.IMAGES_FAST_INDEX_SHARD_BUILDER,
            resource_types.SHARDTOOL_CONFIG,
        )


__Task__ = ImagesBuildUltraIndexBinaries
