# -*- coding: utf-8 -*-

from sandbox.projects.common.BaseImagesBuildIndexBundles import BaseImagesBuildIndexBundles
from sandbox.projects.common.BaseImagesBuildIndexBundle import IndexConfigTask
from sandbox.projects.common.priemka.BasePriemkaTask import generate_priemka_parameters
import sandbox.projects.common.build.parameters as build_params

from sandbox.projects.images.ImagesBuildUltraIndexBinaries import ImagesBuildUltraIndexBinaries
from sandbox.projects.images.ImagesBuildUltraIndexDeployBundle import ImagesBuildUltraIndexDeployBundle


class ImagesBuildUltraIndexBundles(BaseImagesBuildIndexBundles):
    """
        Build all Ultra Images MR Indexer binaries
    """

    type = 'IMAGES_BUILD_ULTRA_INDEX_BUNDLES'

    input_parameters = generate_priemka_parameters(ImagesBuildUltraIndexBinaries.type)

    def initCtx(self):
        self.ctx[build_params.StripBinaries.name] = True

    def get_bundle_types(self):
        subtask_ctx = {IndexConfigTask.name: self.get_mr_index_config_task()}
        return (
            [ImagesBuildUltraIndexDeployBundle.type, subtask_ctx],
        )

    @classmethod
    def get_build_task_type(self):
        return ImagesBuildUltraIndexBinaries.type


__Task__ = ImagesBuildUltraIndexBundles
