# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects.common.BaseImagesBuildIndexBundle import BaseImagesBuildIndexBundle, IndexConfigTask
from sandbox.projects.common import BaseImagesBundleReplaces


class ImagesBuildUltraIndexDeployBundle(BaseImagesBuildIndexBundle):
    """
        Бандл с shardwriter config для ультры
    """

    type = 'IMAGES_BUILD_ULTRA_INDEX_DEPLOY_BUNDLE'

    __STABLE_SERVICES = []
    __TESTING_SERVICES = []

    resource_replaces = (
        [resource_types.IMAGES_SHARDWRITER_CONFIG, BaseImagesBundleReplaces.ShardWriterConfigReplace],
    )

    input_parameters = BaseImagesBuildIndexBundle.input_parameters + \
                       [param for _, param in resource_replaces]

    def get_built_resources(self):
        return ()

    def get_resources_from_tasks(self):
        return (
            [resource_types.IMAGES_SHARDWRITER_CONFIG, self.ctx.get(IndexConfigTask.name)],
        )

    def get_resource_replaces(self):
        return self.resource_replaces

    def get_resource_type(self):
        return resource_types.IMAGES_SHARDWRITER_CONFIG

    def get_resource_descr(self):
        return 'Bundle with shardwriter config for images ultra'

    def get_resource_file_name(self):
        return 'img_ultra_shardwriter_config'

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES


__Task__ = ImagesBuildUltraIndexDeployBundle
