from sandbox import sdk2
import datetime
import subprocess as sp
import os


class ImagesCacheDiff(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        binary = sdk2.parameters.Resource(
            'show_cache_diff',
        )
        input_table = sdk2.parameters.String(
            'Path to table',
            default_value='//home/logfeller/logs/current-eventlog-mmeta/1h/',
        )
        use_dt = sdk2.parameters.Bool(
            'Add time suffix?',
            default_value=True,
        )
        output_table = sdk2.parameters.String(
            'Path to out table',
            default_value='//home/images/dev/show_cache_diff/result_table_',
        )
        cluster_name = sdk2.parameters.String(
            'Cluster Name',
            default_value='hahn',
        )
        reduce_params = sdk2.parameters.String(
            'Reduce params',
            default_value='user_request',
        )
        ignore_params = sdk2.parameters.String(
            'Ignore params',
            default_value='relev::bqbundle&relev::lbqbundle',
        )
        params = sdk2.parameters.String(
            'CGI Params, that affect the cache + &reqid',
            default_value='text&pron&relev&qtree&reqid',
        )
        with sdk2.parameters.Output:
            result_table_url = sdk2.parameters.Url("Result table", hint=True)

    def on_execute(self):
        binary_path = sdk2.ResourceData(self.Parameters.binary).path
        dt_out = (datetime.datetime.now() - datetime.timedelta(hours=4)).strftime("%Y-%m-%dT%H:00:00")
        dt_in = dt_out
        if not self.Parameters.use_dt:
            dt_in = ''

        self.Parameters.result_table_url = 'https://yt.yandex-team.ru/' + self.Parameters.cluster_name + '/navigation?path=' + self.Parameters.output_table + dt_out
        args = [
            str(binary_path),
            '-i', self.Parameters.input_table + dt_in,
            '-o', self.Parameters.output_table + dt_out,
            '-s', self.Parameters.cluster_name,
            '--ignore', self.Parameters.ignore_params,
            '--reduce', self.Parameters.reduce_params,
            '--params', self.Parameters.params,
        ]
        os.environ['YT_TOKEN'] = sdk2.Vault.data(self.owner, 'yt-token')
        sp.Popen(args).wait()

__TASK__ = ImagesCacheDiff
