from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import task

from sandbox.projects import resource_types
from sandbox.projects.common.search import settings as search_settings


class ShardCheckerParameter(parameters.LastReleasedResource):
    name = 'shard_checker_resource_id'
    description = 'Shard checker executable'
    resource_type = resource_types.IMGSEARCH_SHARD_CHECKER_EXECUTABLE


class DatabaseParameter(parameters.ResourceSelector):
    name = 'database_resource_id'
    description = 'Database resource'
    resource_type = [resource_types.IMAGES_SEARCH_DATABASE]
    required = False


class PoliteParameter(parameters.SandboxBoolParameter):
    name = 'polite'
    description = 'Use polite mode'
    default_value = False


# Note: this is a fake resource for database autoselection in TestEnvironment
class QueriesParameter(parameters.ResourceSelector):
    name = 'queries_resource_id'
    description = 'Queries'
    resource_type = resource_types.PLAIN_TEXT_QUERIES
    required = True


class ImagesCheckBasesearchDatabase(task.SandboxTask):
    """
        Run shard_checker utility against specified database
    """

    type = "IMAGES_CHECK_BASESEARCH_DATABASE"

    input_parameters = (
        ShardCheckerParameter,
        DatabaseParameter,
        QueriesParameter,
        PoliteParameter
    )

    execution_space = 120 * 1024

    def on_enqueue(self):
        task.SandboxTask.on_enqueue(self)
        search_settings.ImagesSettings.ensure_search_database(
            self,
            QueriesParameter,
            DatabaseParameter
        )

    def on_execute(self):
        database_path = self.sync_resource(self.ctx[DatabaseParameter.name])
        checker_path = self.sync_resource(self.ctx[ShardCheckerParameter.name])

        cmd = [checker_path, '--index', database_path]
        if self.ctx[PoliteParameter.name]:
            cmd.append('--polite')

        process.run_process(cmd, log_prefix="checker", outputs_to_one_file=False)


__Task__ = ImagesCheckBasesearchDatabase
