import logging
import os

from sandbox import sdk2
from sandbox.projects import resource_types


class ImagesCmApiTask(sdk2.Task):
    """
        Abstract task images CM Api
    """

    class Parameters(sdk2.Parameters):
        cm_url = sdk2.parameters.String("CM graph acceptance url", default_value="https://images-cm-acceptance.n.yandex-team.ru")
        cm_worker_resource_id = sdk2.parameters.Resource(
            "ClusterMaster binaries",
            default_value=1614591200,
            required=True
        )

    def get_cm_api(self):
        from robot.cmpy.library.cmapi import CmApi
        cm_address = self.Parameters.cm_url

        if self.Parameters.cm_worker_resource_id is None:
            cm_worker_res = sdk2.Resource.find(
                resource_type=resource_types.CM_WORKER,
                attrs={"released": "stable"}
                ).order(-sdk2.Resource.id).first()
        else:
            cm_worker_res = self.Parameters.cm_worker_resource_id

        worker_path = str(sdk2.ResourceData(cm_worker_res).path)
        os.environ.update({"CMAPI": " ".join([worker_path, "--cmremote", cm_address])})
        logging.info("CMAPI: %s" % os.getenv("CMAPI"))
        return CmApi()
