import control

from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.online import task
from sandbox.projects.images.pumpkin import resources as images_pumpkin_resources
from sandbox.sandboxsdk.parameters import SandboxStringParameter


class IndexStateParameter(SandboxStringParameter):
    name = 'index_state'
    description = 'Index state'
    required = False


@task.empower(control.ImagesCreateThumbsPlan)
class ImagesCreateThumbsPlan(task.BaseOnlineTask):
    input_parameters = [IndexStateParameter]
    input_resource_type = images_pumpkin_resources.IMAGES_PUMPKIN_INDEX_ARCHIVE
    input_resource_description = "Top queries"
    input_resource_attr_name = "images_pumpkin_ru"
    input_resource_attr_value = "yes"
    output_resource_type = resource_types.IMAGES_THUMBS_PLAN


__Task__ = ImagesCreateThumbsPlan
