from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import environments

from sandbox.projects import resource_types

OUTPUT_PATH = "OUTPUT"


class YtProxyParameter(parameters.SandboxStringParameter):
    name = "yt_proxy"
    description = "YT proxy"
    default_value = "hahn.yt.yandex.net"
    required = True


class SourceTableParameter(parameters.SandboxStringParameter):
    name = "source_table"
    description = "Source table. Must have columns 'url' (by default)"
    required = True


class UrlColumnNameParameter(parameters.SandboxStringParameter):
    name = "url_column"
    description = "Column in source table which contains thumb url"
    default_value = "url"
    required = True


class DebugInfoColumnNameParameter(parameters.SandboxStringParameter):
    name = "debug_info_column"
    description = "Optional column in source table which contains debug info"
    default_value = "debug_info"
    required = True


class YtTokenVaultNameParameter(parameters.SandboxStringParameter):
    name = "vault_yt_token"
    description = "vault resource to take yt token from"
    required = True


class ImagesCreateThumbsPlanFromYt(task.SandboxTask):
    type = "IMAGES_CREATE_THUMBS_PLAN_FROM_YT"

    input_parameters = [
        YtProxyParameter,
        SourceTableParameter,
        UrlColumnNameParameter,
        DebugInfoColumnNameParameter,
        YtTokenVaultNameParameter
    ]

    environment = (
        environments.PipEnvironment("yandex-yt"),
    )

    shoot_plan_resource = resource_types.IMAGES_THUMBS_PLAN

    def create_yt_config(self):
        return {
            "proxy": {
                "url": self.ctx[YtProxyParameter.name],
            },
            "token": self.get_vault_data(self.ctx[YtTokenVaultNameParameter.name])
        }

    def on_enqueue(self):
        self.create_resource(self.descr, OUTPUT_PATH, self.shoot_plan_resource)

    def on_execute(self):
        from yt.wrapper import YtClient
        client = YtClient(config=self.create_yt_config())

        input_table = self.ctx[SourceTableParameter.name]
        if not client.exists(input_table):
            raise Exception("Input table '{}:{}' doesn't exist".format(self.ctx[YtProxyParameter.name], input_table))

        with open(OUTPUT_PATH, "w") as output:
            for row in client.read_table(input_table, format="dsv"):
                url = row[self.ctx[UrlColumnNameParameter.name]]
                comment = row.get(self.ctx[DebugInfoColumnNameParameter.name], "")
                comment = comment.decode('utf-8') if isinstance(comment, unicode) else comment

                output.write("{}\t{}\n".format(url, comment))


__Task__ = ImagesCreateThumbsPlanFromYt
