# coding: utf-8
from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.online import task
from sandbox.common.types.client import Tag
import sandbox.common.types.misc as ctm
import control


@task.empower(control.ImagesExamineCbirIntegrity)
class ImagesExamineCbirIntegrity(task.BaseOnlineTask):
    input_resource_type = resource_types.IMAGES_CBIR_PLAN
    input_resource_description = "Image URLs"
    extra_resource_type = resource_types.CBIR_COMPARER_EXECUTABLE
    extra_resource_description = "CBIR Comparer"
    client_tags = Tag.Group.LINUX
    dns = ctm.DnsType.DNS64


__Task__ = ImagesExamineCbirIntegrity
