# coding: utf-8
from sandbox.projects.common.mediasearch.online import control, command
import itertools as itt

import hashlib
import io
import urlparse


class ImagesExamineThumbsIntegrity(control.BaseControl):
    email_subject_template = "[thumbs-integrity] {descr} results"

    @staticmethod
    def iterate_queries(input_path, queries_count):
        with open(input_path) as f:
            for line in itt.islice(f, queries_count):
                # thumb_url, debug_info
                yield tuple(line.strip().split("\t", 1))

    def process_query(self, thumb_url):
        from PIL import Image
        thumb = self.fetch(thumb_url, "thumbs_404", "thumbs_error")
        self.counter.inc("thumbs_ok")
        thumb_id = urlparse.parse_qs(urlparse.urlparse(thumb_url).query)["id"][0]
        thumb_valid = "valid"
        try:
            Image.open(io.BytesIO(thumb)).verify()
        except Exception as e:
            thumb_valid = e.message
        self.output = "{}\t{}\t{}\n".format(thumb_id, hashlib.md5(thumb).hexdigest(), thumb_valid)

    @staticmethod
    def template_data(res):
        data = []
        total_queries = res.get("total_queries", 0)
        data.append({"name": "Total thumbs", "value": str(total_queries), "fraction": None})

        if total_queries > 0:
            good_thumbs = res.get("thumbs_ok", 0)
            data.append({"name": "Good thumbs",
                         "value": str(good_thumbs),
                         "fraction": float(good_thumbs) / total_queries})

            thumbs_404 = res.get("thumbs_404", 0)
            data.append({"name": "404 thumbs",
                         "value": str(thumbs_404),
                         "fraction": float(thumbs_404) / total_queries})

            thumb_errors = res.get("thumbs_error", 0)
            data.append({"name": "Error thumbs",
                         "value": str(thumb_errors),
                         "fraction": float(thumb_errors) / total_queries})

        return data


if __name__ == '__main__':
    command.command(ImagesExamineThumbsIntegrity)
