# -*- coding: utf-8 -*-

from sandbox.projects.common.balancer_sepe.ocsp import FetchOcspResponse
from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import SandboxSvnUrlParameter, SandboxStringParameter
from sandbox.projects import DeployNannyDashboard


class CertSvnUrlParameter(SandboxSvnUrlParameter):
    """
        Путь до SVN директории с шардмапами
    """
    name = 'svn_cert_url'
    description = 'SVN directory with certs (svn+ssh://url/)'
    default_value = ''


class ReleaseType(SandboxStringParameter):
    name = 'release_type'
    description = 'Release type'
    default = 'stable'
    required = True


class DashboardName(SandboxStringParameter):
    name = 'dashboard_name'
    description = 'Dashboard name'
    default = 'images_runtime'
    required = True


class DashboardFilter(SandboxStringParameter):
    name = 'dashboard_filter'
    description = 'Dashboard filter'
    default = 'thumb_balancer_prod,rim_balancer_prod'
    required = True


class DashboardRecipe(SandboxStringParameter):
    name = 'dashboard_recipe'
    description = 'Deploy recipe'
    default = 'balancer_deploy_ocsp'
    required = True


class ImagesFetchOcspResponse(FetchOcspResponse):
    type = 'IMAGES_FETCH_OCSP_RESPONSE'

    input_parameters = FetchOcspResponse.input_parameters + [
        CertSvnUrlParameter, ReleaseType,
        DashboardName, DashboardFilter, DashboardRecipe
    ]

    @staticmethod
    def _get_svn_cert_url():
        return CertSvnUrlParameter.name

    @staticmethod
    def _get_ocsp_resource_type():
        return resource_types.IMAGES_OCSP_RESPONSE_FILES

    def _release_hook(self):
        deploy_task_params = {
            'deployment_task_id': self.id,
            'deployment_release_status': self.ctx[ReleaseType.name],
            'deployment_nanny_dashboard_name': self.ctx[DashboardName.name],
            'deployment_nanny_dashboard_filter': self.ctx[DashboardFilter.name],
            'deployment_nanny_dashboard_recipe': self.ctx[DashboardRecipe.name],
            'deployment_nanny_bool_wait': False

        }

        releaser = self.create_subtask(
            task_type=DeployNannyDashboard.DeployNannyDashboard.type,
            description='Deploy OCSP',
            input_parameters=deploy_task_params
        )

        self.info = "Subtask {} runned, waiting it's decision about release.\n\n".format(releaser.id)


__Task__ = ImagesFetchOcspResponse
