# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk import parameters

from sandbox.projects import resource_types

JOB_COUNT = "15"


class HamsterRequestExe(parameters.ResourceSelector):
    name = "hamster_request_exe"
    description = "hamsterwheel executable"
    resource_type = resource_types.HAMSTER_REQUEST_EXECUTABLE
    required = True


class RatingTable(parameters.ResourceSelector):
    name = "ratings"
    description = "Rating Table for filling relevance"
    resource_type = resource_types.FML_RATINGS_TABLE
    required = True


class UserQueries(parameters.ResourceSelector):
    name = "user_queries"
    description = "User queries"
    resource_type = resource_types.FML_QUERIES_TABLE
    required = True


class ImagesGetPageRelevances(SandboxTask):
    """
        Задача получения релевантности страниц для списка запрос - URL
    """

    type = 'IMAGES_GET_PAGE_RELEVANCES'
    client_tags = ctc.Tag.Group.LINUX
    input_parameters = (HamsterRequestExe, RatingTable, UserQueries)

    def _get_output_ratings_path(self):
        return self.abs_path("ratings.tsv")

    def initCtx(self):
        # 10 days
        self.ctx['kill_timeout'] = 10 * 24 * 60 * 60

    def on_enqueue(self):
        self.create_resource(
            self.descr,
            self._get_output_ratings_path(),
            resource_types.FML_RATINGS_TABLE,
            arch="any",
        )

    def on_execute(self):
        hamster_request_exe = self.sync_resource(self.ctx[HamsterRequestExe.name])
        urls = self.sync_resource(self.ctx[RatingTable.name])
        queries = self.sync_resource(self.ctx[UserQueries.name])

        run_process(
            [
                hamster_request_exe, "url-relevance", "-u", urls, "-q", queries,
                "-r", self._get_output_ratings_path(), "-j", JOB_COUNT,
                "-c", "&pron=nofreqban&pron=incpessmask0&rearr=scheme_Local/ImgFilterBanned/Bans/Disable=1&pron=garbage&rearr=scheme_Local/Lua/Aspam/time=0"
            ], log_prefix="hamster_request"
        )


__Task__ = ImagesGetPageRelevances
