from sandbox.sandboxsdk.parameters import SandboxIntegerParameter
from sandbox.sandboxsdk.task import SandboxTask

from sandbox.projects.common.priemka import BasePriemkaTask


class ImagesMrIndexCreateBranch(SandboxTask):
    """
        Create a branch from images repository trunk
    """

    type = 'IMAGES_MR_INDEX_CREATE_BRANCH'

    ARCADIA_PROJECT = BasePriemkaTask.ArcadiaProject('images/mrindexer')

    class RevisionParameter(SandboxIntegerParameter):
        """
            Revision repository number
            '0' value means that HEAD revision will be used
        """
        name = BasePriemkaTask.REVISION_PARAMETER_NAME
        description = 'SVN revision'
        required = False

    input_parameters = (RevisionParameter,)

    def on_execute(self):
        if BasePriemkaTask.BRANCH_PARAMETER_NAME not in self.ctx:
            all_branches = sorted(self.ARCADIA_PROJECT.list_branches(), key=lambda x: x.number)
            new_branch_number = all_branches[-1].number + 1 if all_branches else 0
            branch = BasePriemkaTask.ArcadiaProject.Branch(self.ARCADIA_PROJECT, new_branch_number)
            branch.create_from_trunk(self.ctx[BasePriemkaTask.REVISION_PARAMETER_NAME])
            self.ctx[BasePriemkaTask.BRANCH_PARAMETER_NAME] = branch.basename()
