import json

from sandbox.sandboxsdk import parameters
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common.search.basesearch import task as basesearch_task
from sandbox.projects.images.basesearch import ImagesAnalyzeBasesearchPerformance as analyze_task

from sandbox.projects.images import ImagesPriemkaBasesearchDatabase as images_basesearch_database


class MiddlesearchShardName(parameters.SandboxStringParameter):
    name = 'middlesearch_shard_name'
    description = 'Middlesearch shard name'


class ImagesPriemkaBasesearchQuickDatabase(images_basesearch_database.ImagesPriemkaBasesearchDatabase):
    """
        Images search quick database acceptance task
    """

    type = 'IMAGES_PRIEMKA_BASESEARCH_QUICK_DATABASE'

    input_parameters = (MiddlesearchShardName,) + \
        images_basesearch_database.ImagesPriemkaBasesearchDatabase.input_parameters

    ###
    def _get_tests(self):
        return (
            (media_settings.INDEX_QUICK, "search", None),
            (media_settings.INDEX_QUICK, "snippets", None)
            #  TODO: uncomment, when we've get cbir shards at fast shardmap
            #  (media_settings.INDEX_CBIR_QUICK, "search", None),
            #  (media_settings.INDEX_CBIR_QUICK, "snippets", None),
        )

    def _get_basesearch_performance_args(self, index_type, query_type):
        sub_ctx = self._get_basesearch_shooting_parameters(index_type)

        cgroup_props = json.dumps(media_settings.ImagesSettings.CGROUPS[index_type])
        sub_ctx.update({
            analyze_task.BASESEARCH1_PARAMS.Cgroup.name: cgroup_props,
            analyze_task.BASESEARCH2_PARAMS.Cgroup.name: cgroup_props,
        })

        if query_type == "snippets":
            sub_ctx.update({
                basesearch_task.RamdriveEnabledParameter.name: True,
                basesearch_task.RamdriveSizeParameter.name: media_settings.ImagesSettings.SNIPPETS_RAMDRIVE_SIZE,
                basesearch_task.RamdriveFilesParameter.name: " ".join(media_settings.ImagesSettings.SNIPPETS_RAMDRIVE_FILES),
            })

        return sub_ctx

    def _get_basesearch_shooting_parameters(self, index_type):
        return media_settings.ImagesSettings.basesearch_shooting_parameters(index_type)

    def _get_shard_name(self, age, index_type):
        if index_type == media_settings.INDEX_MIDDLE and self.ctx.get(MiddlesearchShardName.name):
            return [self.ctx[MiddlesearchShardName.name]]
        return images_basesearch_database.ImagesPriemkaBasesearchDatabase._get_shard_name(self, age, index_type)


__Task__ = ImagesPriemkaBasesearchQuickDatabase
