import json

from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common.mediasearch.acceptance import database as search_database

from sandbox.projects.images import ImagesLoadBasesearchDatabase as load_task
from sandbox.projects.images.basesearch import ImagesAnalyzeBasesearchPerformance as analyze_task
from sandbox.projects.images.resources import task as resources_task


class ImagesPriemkaBasesearchRqDatabase(resources_task.ImagesProductionResourcesTask,
                                        search_database.BasePriemkaDatabaseTask):
    """
        Images search database acceptance task
    """

    type = 'IMAGES_PRIEMKA_BASESEARCH_RQ_DATABASE'

    ###
    def _get_tests(self):
        return ((media_settings.INDEX_RQ, "all", None),)

    def _get_index_type_for_tier(self, tier):
        return media_settings.ImagesSettings.index_type_for_tier(tier)

    ###
    def _get_database_task(self, index_type):
        return load_task.ImagesLoadBasesearchDatabase.type

    def _get_database_args(self, index_type):
        return {
            load_task.IndexTypeParameter.name: index_type,
        }

    def _get_database_resource(self, index_type):
        return media_settings.ImagesSettings.basesearch_database_resource(index_type)

    def _get_middlesearch_index_type(self):
        return media_settings.INDEX_MIDDLE_RQ

    ###
    def _get_basesearch_performance_task(self, index_type):
        task_type = analyze_task.ImagesAnalyzeBasesearchPerformance.type
        basesearch_params = (
            analyze_task.BASESEARCH1_PARAMS,
            analyze_task.BASESEARCH2_PARAMS,
        )
        plan_params = (
            analyze_task.Plan1Parameter,
            analyze_task.Plan2Parameter,
        )
        return task_type, basesearch_params, plan_params

    def _get_basesearch_performance_args(self, index_type, query_type):
        sub_ctx = self._get_basesearch_shooting_parameters(index_type)

        cgroup_props = json.dumps(media_settings.ImagesSettings.CGROUPS[index_type])
        sub_ctx.update({
            analyze_task.BASESEARCH1_PARAMS.Cgroup.name: cgroup_props,
            analyze_task.BASESEARCH2_PARAMS.Cgroup.name: cgroup_props,
        })

        return sub_ctx

    def _get_basesearch_shooting_parameters(self, index_type):
        return media_settings.ImagesSettings.basesearch_shooting_parameters(index_type)

    def _get_shard_name(self, age, index_type):
        if index_type == media_settings.INDEX_MIDDLE_RQ:
            return None
        else:
            return search_database.BasePriemkaDatabaseTask._get_shard_name(self, age, index_type)


__Task__ = ImagesPriemkaBasesearchRqDatabase
