from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
from sandbox.common.types.task import Semaphores
import sandbox.common.types.task as ctt

from . import component


NANNY_API_URL = "http://nanny.yandex-team.ru/"


class ImagesPriemkaRtRobot(sdk2.Task):
    """
        Images rt-robot acceptance
    """

    class Parameters(sdk2.Parameters):
        nanny_rt_robot_service_name = sdk2.parameters.String("The name  of robot acceptance service",
                                                             default_value="acceptance_sas_quickd_yp")
        nanny_indexproxy_service_name = sdk2.parameters.String("The name of indexer acceptance service",
                                                               default_value="saas_refresh_acceptance_images_quick_indexerproxy")
        nanny_distributors_service_name = sdk2.parameters.String("The name of distributors acceptance service",
                                                                 default_value="saas_refresh_acceptance_images_quick_distributors")
        nanny_saas_base_service_name = sdk2.parameters.String("The name of saas base acceptance service",
                                                              default_value="saas_refresh_acceptance_images_quick_base_sas")
        saas_nanny_services_activation_timeout = sdk2.parameters.Integer("Activation timeout in sec", default_value=1200)
        minutes_in_future_to_drop = sdk2.parameters.Integer("Minutues from now when db will be removing on service activation", default_value=10)
        file_with_drop_time = sdk2.parameters.String("Static file with time before which db will be removing on service activation", default_value="drop_db_ts")

        mr_config_param = sdk2.parameters.String("IMAGES_MR_INDEX_CONFIG")
        quick_bundle_param = sdk2.parameters.String("IMAGES_BUILD_QUICK_PACKAGE")

    class Context(sdk2.Task.Context):
        mr_config = None
        quick_bundle = None

    def __get_nanny(self):
        return nanny.NannyClient(api_url=NANNY_API_URL, oauth_token=sdk2.Vault.data("MEDIA_DEPLOY", "nanny-oauth-token"))

    def get_saas_nanny_service(self):
        service = component.SaasComponent(self, self.__get_nanny(),
                                          self.Parameters.saas_nanny_services_activation_timeout,
                                          self.Parameters.minutes_in_future_to_drop,
                                          self.Parameters.file_with_drop_time)

        return service

    def get_robot_nanny_service(self):
        mr_config = self.Parameters.mr_config_param if self.Parameters.mr_config_param is not None else self.Context.mr_config
        quick_bundle = self.Parameters.quick_bundle_param if self.Parameters.quick_bundle_param is not None else self.Context.quick_bundle

        service = component.RobotComponent(self, self.__get_nanny(),
                                           self.Parameters.saas_nanny_services_activation_timeout,
                                           mr_config_resource_id=mr_config,
                                           quick_bundle_task_id=quick_bundle)
        return service

    def on_enqueue(self):
        self.Requirements.semaphores = Semaphores(acquires=[
            Semaphores.Acquire(name=self.type.name, capacity=1)
        ])

    def on_execute(self):
        with self.memoize_stage.wait_nanny(commit_on_entrance=False):
            saas = self.get_saas_nanny_service()
            robot = self.get_robot_nanny_service()
            tasks = saas.find_running_tasks() + robot.find_running_tasks()
            if tasks:
                raise sdk2.WaitTask(tasks, list(ctt.Status.Group.FINISH + ctt.Status.Group.BREAK), wait_all=True)

        with self.memoize_stage.own_services(commit_on_entrance=False):
            self.get_saas_nanny_service().own_service()
            self.get_robot_nanny_service().own_service()

        with self.memoize_stage.stop_robot(commit_on_entrance=False):
            self.get_robot_nanny_service().stop()

        with self.memoize_stage.shift_lb(commit_on_entrance=False):
            # TODO(igorluk): shift LB pointers
            pass

        with self.memoize_stage.saas_drop_database(commit_on_entrance=False):
            self.get_saas_nanny_service().drop_db()

        with self.memoize_stage.update_robot(commit_on_entrance=False):
            self.get_robot_nanny_service().update()

        with self.memoize_stage.start_robot(commit_on_entrance=False):
            self.get_robot_nanny_service().start()

        # TODO(igorluk): wait 7days and get mlm
