from sandbox import sdk2
from sandbox.projects.common.nanny import nanny


class ImagesMiddlesearchModelsTimestamp(sdk2.Resource):
    """ Dynamic models timestamp resource (used as part of middlesearch cache generation) """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = ['robot-images-sandbox', 'krivokon', 'gilazhev', 'pupatenko']


class ImagesBuildMiddlesearchModelsTimestamp(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ Build and release timestamp resource used as images middlesearch cache generation tag """

    class Parameters(sdk2.Task.Parameters):
        timestamp = sdk2.parameters.String('Timestamp', required=True)

    def on_execute(self):
        resource = sdk2.ResourceData(ImagesMiddlesearchModelsTimestamp(
            self, 'Middlesearch dynamic models timestamp file', 'models_timestamp.txt'
        ))
        resource.path.write_bytes('{}'.format(self.Parameters.timestamp))
