from sandbox import sdk2
from sandbox.common.types.task import Semaphores
from sandbox.projects.images.ImagesCmApi.task import ImagesCmApiTask


class ImagesRobotBranchAcceptance(ImagesCmApiTask):
    """
        Images robot branch acceptance
    """

    class Parameters(ImagesCmApiTask.Parameters):
        pass

    class Context(sdk2.Task.Context):
        pass

    def on_create(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(attrs={'name': 'ImagesRobotBranchAcceptance'}).first()

    def on_enqueue(self):
        self.Requirements.semaphores = Semaphores(acquires=[
            Semaphores.Acquire(name=self.type.name, capacity=1)
        ])

    def on_execute(self):
        with self.memoize_stage.prepare_cm_graph(commit_on_entrance=False):
            cmapi = super(ImagesRobotBranchAcceptance, self).get_cm_api()
            cmapi.mark_success("acceptance-finish")
            cmapi.mark_success("acceptance-finish-mandatory")

        with self.memoize_stage.start_acceptance(commit_on_entrance=False):
            cmapi = super(ImagesRobotBranchAcceptance, self).get_cm_api()
            cmapi.reset_whole_path("workflow-finish")
            cmapi.run_whole_path("workflow-finish")
