# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import SandboxUrlParameter

from sandbox.projects.common import utils
from sandbox.projects.common.search import settings as media_settings

from sandbox.projects.images import responses as images_responses
from sandbox.projects.images import ImagesUploadSaas as upload_saas
from sandbox.projects.images import ImagesGetSaasResponses as  saas_responses
from sandbox.projects.images.resources import task as images_resources_tasks


class QueriesParameter(images_responses.RESPONSE_SAVER_PARAMS.QueriesParameter):
    """
        Запросы для обстрела
    """
    required = False


class QueriesLimitParameter(images_responses.RESPONSE_SAVER_PARAMS.QueriesLimitParameter):
    """
        Лимит запросов для обстрела
    """
    default_value = 10000
    required = False


class MaxEmptyResponsesRate(images_responses.MaxEmptyResponsesRate):
    """
        Допустимая доля пустых ответов
    """
    default_value = 0.80


_BASE_SEARCH_RESPONSES_TASK = 'get_remote_base_search_responses'

_SAAS_CLUSTER_GROUP = "Saas base search"


class SaasBasesearchUrl(SandboxUrlParameter):
    name = 'saas_basesearch_addr'
    description = 'Url SAAS basesearch'
    required = True
    group = _SAAS_CLUSTER_GROUP


class ImagesRtUltraAcceptance(images_resources_tasks.ImagesProductionResourcesTask, SandboxTask):
    """
        Принимаем рантайм контур картиночной ультры
    """
    type = 'IMAGES_RT_ULTRA_ACCEPTANCE'

    input_parameters = (
        QueriesParameter,
        QueriesLimitParameter,
        MaxEmptyResponsesRate,
        SaasBasesearchUrl,
    ) + upload_saas.ImagesUploadSaas.input_parameters

    RESPONSES_STATS_KEY = saas_responses.ImagesGetSaasResponses.RESPONSES_STATS_KEY

    def __find_last_testing_queries(self):
        return self._get_middlesearch_queries(media_settings.INDEX_MIDDLE, media_settings.INDEX_ULTRA)

    def __run_get_basesearch_reponses(self):
        subtask_ctx = {
            saas_responses.ImagesGetSaasResponses.SAAS_BASE_SEARCH_URL:
                utils.get_or_default(self.ctx, SaasBasesearchUrl),
            saas_responses.ImagesGetSaasResponses.QUERIES_SOURCE:
                utils.get_or_default(self.ctx, QueriesParameter) or self.__find_last_testing_queries(),
            saas_responses.ImagesGetSaasResponses.QUERIES_LIMIT:
                utils.get_or_default(self.ctx, QueriesLimitParameter),
            saas_responses.ImagesGetSaasResponses.QUERIES_EMPTY_LIMIT:
                utils.get_or_default(self.ctx, MaxEmptyResponsesRate),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_BINARY:
                self._get_middlesearch_executable(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_REARANGE_DATA:
                self._get_middlesearch_data(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_REARANGE_INDEX:
                self._get_middlesearch_index(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_MODELES:
                self._get_middlesearch_models(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_CONFIG:
                self._get_middlesearch_config(),
        }

        task = channel.task.create_subtask(
            task_type=saas_responses.ImagesGetSaasResponses.type,
            description=self.descr,
            input_parameters=subtask_ctx)

        self.ctx[_BASE_SEARCH_RESPONSES_TASK] = task.id

    def on_execute(self):
        with self.memoize_stage.run_grap_responses(commit_on_entrance=False):
            self.__run_get_basesearch_reponses()

        with self.memoize_stage.wait_responses(commit_on_entrance=False):
            utils.wait_all_subtasks_stop()

        with self.memoize_stage.check_responses(commit_on_entrance=False):
            responses_task = channel.sandbox.get_task(self.ctx[_BASE_SEARCH_RESPONSES_TASK])
            self.ctx[self.RESPONSES_STATS_KEY] = responses_task.ctx.get(self.RESPONSES_STATS_KEY, {})

            utils.check_subtasks_fails(fail_on_first_failure=True)


__Task__ = ImagesRtUltraAcceptance
