# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects.common.DeployMediaShardmap import DeployMediaShardmap
from sandbox.projects.DeployNannyShardmap import ShardmapResource


class ImagesShardmapCbirQuick(DeployMediaShardmap):
    """
        Деплоим быстрый контур картиночной сибири:
        * получаем шардмап на деплой в качестве параметра
        * запускаем деплой в указанном сервисе nanny и ждём его завершения
    """

    type = 'IMAGES_SHARDMAP_CBIR_QUICK'

    input_parameters = [
        ShardmapResource
    ]

    def _get_nanny_service_to_deploy(self):
        return 'production_imgfcbr'

    def _get_shardmap_resource_type(self):
        return resource_types.IMAGES_FAST_CBIR_SHARDMAP

    def on_execute(self):
        pass


__Task__ = ImagesShardmapCbirQuick
