# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types

from sandbox.projects.common.BaseGetShardmapTask import ShardmapSvnUrlParameter
from sandbox.projects.common.DeployMediaShardmap import DeployMediaShardmap
from sandbox.projects.common.utils import check_subtasks_fails

from sandbox.projects.DeployNannyShardmap import ShardmapResource
from sandbox.projects.DeployNannyShardmap import NannyServiceNameParameter

from sandbox.projects.common.DeployMediaShardmap import NannyThumbServiceNameParameter
from sandbox.projects.common.DeployMediaShardmap import ImportedShardmapResourceParameter

from sandbox.projects import GetMediaShardmapFromSvnTask
from sandbox.projects.common.nanny import nanny


class ImagesShardmapCbirQuickBySvn(DeployMediaShardmap):
    """
        Отслеживаем новый шардмап в svn директории и деплоим его в сервис.
        После успешного завершения даём ссылку на релиз шардмапа для выкатки
        его в продакшен.
    """

    type = 'IMAGES_SHARDMAP_CBIR_QUICK_BY_SVN'

    input_parameters = [
        ShardmapSvnUrlParameter,
        NannyServiceNameParameter,
        NannyThumbServiceNameParameter,
        ImportedShardmapResourceParameter,
    ]

    def _get_shardmap_resource_type(self):
        return resource_types.IMAGES_SHARDMAP_CBIR_QUICK_RESOURCE

    def _get_shardmap_task_type(self):
        return GetMediaShardmapFromSvnTask.GetMediaShardmapFromSvnTask.type

    def on_execute(self):
        # get oauth token
        nanny_client = nanny.NannyClient(
            api_url='http://nanny.yandex-team.ru/',
            oauth_token=self.get_vault_data('MEDIA_DEPLOY', 'nanny-oauth-token'),
        )

        # wait subtasks if exists
        subtasks = channel.sandbox.list_tasks(parent_id=self.id)
        tasks_to_wait = filter(lambda x: not x.is_done(), subtasks)
        if tasks_to_wait:
            check_subtasks_fails(fail_on_first_failure=True)

        current_state = nanny_client.get_service_current_state(
            self.ctx[NannyServiceNameParameter.name])
        service_status = current_state[u'content'][u'summary'][u'value']
        # just copy shardmap from another resource without any deployment (generally for inital movement to nanny)
        if self.ctx[ImportedShardmapResourceParameter.name] is not None:
            self.ctx[ShardmapResource.name] = self._copy_resource(self.ctx[ImportedShardmapResourceParameter.name])
        else:
            # make some changes only if service in ONLINE state
            if service_status == u'ONLINE':
                # find new shardmaps to deploy
                if u'deployment_shardmap' not in self.ctx:
                    self.ctx[u'deployment_shardmap'] = self._get_shardmap_to_deploy(nanny_client, current_state)
                if self.ctx[u'deployment_shardmap'] is not None:
                    # get production timestamp for thumbnails
                    self.ctx[u'thumb_timestamp'] = self._get_thumbs_shardmap(nanny_client)
                    if self.ctx[u'thumb_timestamp'] is not None:
                        # compare timestamps of thumb and index:
                        if self.ctx[u'deployment_timestamp'] <= self.ctx[u'thumb_timestamp']:
                            # run deployment
                            self.ctx[ShardmapResource.name] = self._copy_resource(self.ctx[u'deployment_shardmap'])
                            self._run_nanny_deploy(wait_before_deploy=False, wait_deploy=False, auto_deploy=False)


__Task__ = ImagesShardmapCbirQuickBySvn
