# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects.common.DeployMediaShardmap import DeployMediaShardmap
from sandbox.projects.DeployNannyShardmap import ShardmapResource


class ImagesShardmapThumb(DeployMediaShardmap):
    """
        Деплоим большой контур картиночных тумбнейлов:
        * получаем шардмап на деплой в качестве параметра
        * запускаем деплой на приёмку в указанном сервисе nanny и ждём его завершения
        * [TODO] апдейтим версию базы в ITS
        * ? [TODO] апдейтим флажки в зукипере
    """

    type = 'IMAGES_SHARDMAP_THUMB'

    input_parameters = [
        ShardmapResource
    ]

    def _get_nanny_service_to_deploy(self):
        return 'acceptance_imgsthwide'

    def _get_shardmap_resource_type(self):
        return resource_types.IMAGES_THUMB_SHARDMAP

    def on_execute(self):
        pass


__Task__ = ImagesShardmapThumb
