# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types

from sandbox.projects.common.BaseGetShardmapTask import ShardmapSvnUrlParameter
from sandbox.projects.common.DeployMediaShardmap import DeployMediaShardmap
from sandbox.projects.common.utils import check_subtasks_fails

#from projects.DeployNannyShardmap import ShardmapResource
from sandbox.projects.DeployNannyShardmap import NannyServiceNameParameter

from sandbox.projects.common.DeployMediaShardmap import ImportedShardmapResourceParameter

from sandbox.projects import GetMediaShardmapFromSvnTask
from sandbox.projects.common.nanny import nanny


class ImagesShardmapThumbBySvn(nanny.ReleaseToNannyTask, DeployMediaShardmap):
    """
        Отслеживаем новый шардмап в svn директории и деплоим его в сервис.
        После успешного завершения даём ссылку на релиз шардмапа для выкатки
        его в продакшен.
    """

    type = 'IMAGES_SHARDMAP_THUMB_BY_SVN'

    input_parameters = [
        ShardmapSvnUrlParameter,
        NannyServiceNameParameter,
        ImportedShardmapResourceParameter
    ]

    def _get_shardmap_resource_type(self):
        return resource_types.IMAGES_THUMB_SHARDMAP

    def _get_shardmap_task_type(self):
        return GetMediaShardmapFromSvnTask.GetMediaShardmapFromSvnTask.type

    def on_execute(self):
        self.ctx['shardmaps_to_release'] = []

        # get oauth token
        nanny_client = nanny.NannyClient(
            api_url='http://nanny.yandex-team.ru/',
            oauth_token=self.get_vault_data('MEDIA_DEPLOY', 'nanny-oauth-token'),
        )

        # wait subtasks if exists
        subtasks = channel.sandbox.list_tasks(parent_id=self.id)
        tasks_to_wait = filter(lambda x: not x.is_done(), subtasks)
        if tasks_to_wait:
            check_subtasks_fails(fail_on_first_failure=True)

        child_tasks = []
        # just copy shardmap from another resource without any deployment (generally for inital movement to nanny)
        if self.ctx[ImportedShardmapResourceParameter.name] is not None:
            pass
            #self.ctx[ShardmapResource.name] = self._copy_resource(self.ctx[ImportedShardmapResourceParameter.name])
        else:
            for service_name in self.ctx[NannyServiceNameParameter.name].split(','):
                current_state = nanny_client.get_service_current_state(service_name)
                if current_state[u'content'][u'summary'][u'value'] == u'ONLINE':
                    # find new shardmaps to deploy
                    deployment_shardmap = self._get_shardmap_to_deploy(nanny_client, current_state)
                    if deployment_shardmap is not None and deployment_shardmap not in self.ctx['shardmaps_to_release']:
                        # run deployment
                        # if ShardmapResource.name not in self.ctx:
                            #self.ctx[ShardmapResource.name] = self._copy_resource(deployment_shardmap)
                        #child_task = self._run_nanny_deploy_neat(wait_before_deploy=False, wait_deploy=False, auto_deploy=False, service_name=service_name)
                        # child_tasks.append(child_task)
                        shardmap_resource = channel.sandbox.get_resource(deployment_shardmap)
                        self.create_release(shardmap_resource.task_id, status='testing')
                        self.ctx['shardmaps_to_release'].append(deployment_shardmap)
        if child_tasks:
            self.wait_all_tasks_stop_executing(child_tasks)


__Task__ = ImagesShardmapThumbBySvn
