# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types

from sandbox.projects.common.BaseGetShardmapTask import ShardmapSvnUrlParameter
from sandbox.projects.common.DeployMediaShardmap import DeployMediaShardmap
from sandbox.projects.common.utils import check_subtasks_fails

from sandbox.projects.DeployNannyShardmap import ShardmapResource
from sandbox.projects.DeployNannyShardmap import NannyServiceNameParameter

from sandbox.projects import GetMediaShardmapFromSvnTask
from sandbox.projects.common.nanny import nanny


class ImagesShardmapThumbQuickBySvn(DeployMediaShardmap):
    """
        Отслеживаем новый шардмап в svn директории и деплоим его в сервис.
        После успешного завершения даём ссылку на релиз шардмапа для выкатки
        его в продакшен.
    """

    type = 'IMAGES_SHARDMAP_THUMB_QUICK_BY_SVN'

    input_parameters = [
        ShardmapSvnUrlParameter,
        NannyServiceNameParameter,
    ]

    def _get_shardmap_resource_type(self):
        return resource_types.IMAGES_QUICK_THUMB_SHARDMAP

    def _get_shardmap_task_type(self):
        return GetMediaShardmapFromSvnTask.GetMediaShardmapFromSvnTask.type

    def on_execute(self):
        # get oauth token
        nanny_client = nanny.NannyClient(
            api_url='http://nanny.yandex-team.ru/',
            oauth_token=self.get_vault_data('MEDIA_DEPLOY', 'nanny-oauth-token'),
        )

        subtasks = channel.sandbox.list_tasks(parent_id=self.id)
        tasks_to_wait = filter(lambda x: not x.is_done(), subtasks)
        if tasks_to_wait:
            check_subtasks_fails()

        if 'production_timestamp' not in self.ctx and self.ctx[NannyServiceNameParameter.name] != "":
            self.ctx['production_timestamp'] = self._get_production_timestamp(nanny_client)

        if 'raw_resource_id' not in self.ctx:
            if self.ctx[NannyServiceNameParameter.name] == "":
                self.ctx['raw_resource_id'] = self._get_deployment_shardmap_by_svn()
            else:
                shardmap_from_sandbox = self._get_deployment_shardmap_by_sandbox(self.ctx['production_timestamp'])
                if shardmap_from_sandbox:
                    self.ctx['raw_resource_id'] = shardmap_from_sandbox
                else:
                    # get shardmap to deploy from svn
                    self.ctx['raw_resource_id'] = self._get_deployment_shardmap_by_svn()

        if self.ctx['raw_resource_id'] is not None:
            self.ctx[ShardmapResource.name] = self._copy_resource(self.ctx['raw_resource_id'])
            if self._compare_timestamps():
                self._run_nanny_deploy(wait_before_deploy=False, wait_deploy=False, auto_deploy=False)


__Task__ = ImagesShardmapThumbQuickBySvn
