# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.projects import resource_types


class MapreduceServer(SandboxStringParameter):
    name = 'server'
    description = 'Mapreduce server'
    required = False


class MapreduceBasePrefix(SandboxStringParameter):
    name = 'prefix'
    description = 'Mapreduce path prefix of base'
    required = False
    default_value = 'images'


class ImagesStoreIndexLocation(SandboxTask):
    """
        Stores index location info file.
    """

    type = 'IMAGES_STORE_INDEX_LOCATION'
    input_parameters = [MapreduceServer, MapreduceBasePrefix]

    def on_execute(self):
        file_name = "location"
        resource = self.create_resource(
            "",
            file_name,
            resource_types.IMAGES_INDEX_LOCATION
        )
        with open(file_name, "w") as f:
            f.write("{server} {path}".format(
                server=self.ctx.get(MapreduceServer.name),
                path=self.ctx.get(MapreduceBasePrefix.name)))
        channel.task.mark_resource_ready(resource)

    @property
    def footer(self):
        return ('<h4><a href="https://yt.yandex-team.ru/{server}/#page=navigation&path={path}">Viewer</a></h4>'
                .format(server=self.ctx.get(MapreduceServer.name),
                        path=self.ctx.get(MapreduceBasePrefix.name)))


__Task__ = ImagesStoreIndexLocation
