# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxStringParameter

from sandbox.projects.MediaLib.MediaStoreShardmap import MediaStoreShardmap, ShardmapType, SwitchDashboardName, NewDBDashboardName, RollbackActivateRecipe

from sandbox.projects.MediaLib.SwitchMediaDatabase import SwitchDashboardRecipe
from sandbox.projects.MediaLib.UploadMediaDatabase import NewDBDashboardRecipe

SWITCH_DASHBOARD_NAME = 'images_all'
NEWDB_DASHBOARD_NAME = 'images_newdb'
NEWDB_DASHBOARD_NAME_WITH_T1 = 'images_newdb_with_tier1'
ROLLBACK_ACTIVE_RECIPE = 'default'
DATABASE_SWTICH_RECIPE = 'switch_images_database'
DATABASE_SWITCH_RECIPE_WITH_T1 = 'switch_images_database_with_tier1'
NEWDB_RECIPE = 'deploy_images_newdb'


class PrimaryShardsCount(SandboxStringParameter):
    name = 'primary_shards_count'
    description = 'Primary shards count'
    required = False
    default_value = '432'


class GarbageShardsCount(SandboxStringParameter):
    name = 'garbage_shards_count'
    description = 'Garbage tier shards count'
    required = False
    default_value = '432'


class PlatinumShardsCount(SandboxStringParameter):
    name = 'platinum_shards_count'
    description = 'Platinum shards count'
    required = False
    default_value = '0'


class ImagesStoreShardmap(MediaStoreShardmap):
    """Переключение большой базы Картинок"""

    type = 'IMAGES_STORE_SHARDMAP'
    input_parameters = MediaStoreShardmap.input_parameters + (ShardmapType, PrimaryShardsCount, PlatinumShardsCount, GarbageShardsCount)

    # type to switch
    switch_type = 'images'

    # task to release for shard
    SHARDMAP_RESOURCE = 'IMAGES_BASE_SHARDMAP'

    # sandbox tasks for nanny
    UPLOAD_TASK = "UPLOAD_IMAGES_DATABASE_NG"
    WAIT_UPLOAD_TASK = "WAIT_UPLOAD_IMAGES_DATABASE"

    # YDL
    YDL_TOKEN_NAME = 'ydl_images_token'

    # Monitoring settings
    monitoring_sleep = 3 * 60  # 3 min
    monitoring_time = 30 * 60  # 30 min
    monitoring_telegram_chat_id = '-1001088652476'
    monitoring_email_to = 'images-newdb@yandex-team.ru'
    monitoring_vault_name = 'telegram_token'
    monitoring_vault_owner = 'MEDIA_DEPLOY'

    def initCtx(self):
        MediaStoreShardmap.initCtx(self)

        # override inputs
        self.ctx[ShardmapType.name] = self.SHARDMAP_RESOURCE
        self.ctx[SwitchDashboardName.name] = SWITCH_DASHBOARD_NAME

        self.ctx[SwitchDashboardRecipe.name] = DATABASE_SWTICH_RECIPE
        self.ctx[NewDBDashboardName.name] = NEWDB_DASHBOARD_NAME
        self.ctx[SwitchDashboardName.name] = SWITCH_DASHBOARD_NAME
        self.ctx[NewDBDashboardRecipe.name] = NEWDB_RECIPE
        # for cancelation
        self.ctx[RollbackActivateRecipe.name] = ROLLBACK_ACTIVE_RECIPE

    def generate_all_shardmap(self, state, meta_state, shardmap_file):
        # generate imgmmeta ImgMmetaTier0
        shardmap_file.write(self.shardmap_entry('imgmmeta', 0, meta_state, 'ImgMmetaTier0'))

        # generate imgsidx ImgTier0
        count = int(self.ctx[PrimaryShardsCount.name])
        for shard in range(count):
            shardmap_file.write(self.shardmap_entry('imgsidx', shard, state, 'ImgTier0'))

        # generate imgsidx ImgTier1
        count_garbage = int(self.ctx[GarbageShardsCount.name])
        for shard in range(count_garbage):
            shardmap_file.write(self.shardmap_entry('imgsidxt1', shard, state, 'ImgTier1'))

        if count_garbage > 0:
            self.ctx[SwitchDashboardRecipe.name] = DATABASE_SWITCH_RECIPE_WITH_T1
            self.ctx[NewDBDashboardName.name] = NEWDB_DASHBOARD_NAME_WITH_T1
        else:
            self.ctx[SwitchDashboardRecipe.name] = DATABASE_SWTICH_RECIPE
            self.ctx[NewDBDashboardName.name] = NEWDB_DASHBOARD_NAME

        # generate imgpidx ImgPlatinumTier0
        platinum_count = int(self.ctx[PlatinumShardsCount.name])
        for shard in range(platinum_count):
            shardmap_file.write(self.shardmap_entry('imgpidx', shard, state, 'ImgPlatinumTier0'))

    def get_switch_recipe_name(self):
        return DATABASE_SWTICH_RECIPE


__Task__ = ImagesStoreShardmap
