# -*- coding: utf-8 -*-
import re
import requests
from sandbox.projects.MediaLib.media_zk import zk_client
from sandbox.projects.MediaLib.media_zk import MediaZkClient
from sandbox.projects.MediaLib.media_zk import ZkFunctions

from sandbox.projects import resource_types
from sandbox.projects.common import apihelpers
from sandbox import sdk2

class ImagesTestMediaZkFlags(sdk2.Task):
    """
        Testing media-zookeeper
    """

    class Parameters(sdk2.task.Parameters):
        kill_timeout = 2000
        zk_path = sdk2.parameters.String('Test zk path', required=True)
        zk_value = sdk2.parameters.String('Test zk value', required=True)


    def on_execute(self):
        with MediaZkClient() as zk:
            znode = "%s" % (self.Parameters.zk_path.rstrip('/'))
            ZkFunctions.set_forced(zk, znode, self.Parameters.zk_value)


