from sandbox.projects import resource_types
import sandbox.common.types.resource as ctr
import sandbox.projects.images.ImagesTestSaasBasics as saas_basics
from sandbox import sdk2

from sandbox.sandboxsdk.process import run_process


class RunImagesFusionProductionEnv(saas_basics.RunFusionProductionEnvBase):
    class Parameters(saas_basics.RunFusionProductionEnvBase.Parameters):
        sw_config = sdk2.parameters.Resource(
            'shard writer config',
            resource_type=resource_types.IMAGES_SHARDWRITER_CONFIG,
            state=(ctr.State.READY, ),
            required=False,
        )

    def get_extra_params(self):
        base_extra_params = super(RunImagesFusionProductionEnv, self).get_extra_params()
        base_extra_params["SHARDWRITER_CONFIG"] = self.obtained_resources['sw_config']
        return base_extra_params
